$(document).ready(async function () {
  const permissaoUsuarioLogado = await permissaoAcessos("CLATRIB");

  $("#btnFiltros").on("click", async function () {
    $("#modal-filtros").modal("show");
  });

  $("#btnNovaClaTrib").on("click", async function () {
    if (permissaoUsuarioLogado.INCLUI == 'S') {
        window.location.href = "clatrib/create";
    } else {  
        msgAlertaSemConfirmacao("Sem permissão para incluir!");
    }
  });



  $("#txtCSTICMSconsulta").autocompleta(
    1,
    `JSON={ "tabela":"tabtri", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`
  );
  // pesquisa
  $("#btn-CSTICMS").pesquisa(
    "#txtCSTICMSconsulta",
    "CODIGO",
    "DESCRICAO",
    `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabtri", "camposSelect":[ "codigo", "descricao"]}`,
    "Pesquisa CST ICMS",
    "tabtri"
  );
  // limpaCampo
  $("#btn-limpa-CSTICMS").on("click", function () {
    $("#txtCSTICMSconsulta").val("");
  });

  function retornaBotaoOpcoes() {
    return (
      '<div class="divBtnOpcoes"> ' +
      '    <button class="botaoOpcoes" type="button" title="Editar" id="btn-editar"><span class="fas fa-edit" style="color:green"></span></button>      ' +
      '    <button class="botaoOpcoes" type="button" title="Excluir" id="btn-excluir"><span class="fas fa-trash-alt" style="color:red"></span></button>  ' +
      "   </div>"
    );
  }

  function retornaBotaoOpcoes(data) {
    var retorno = '<div style="text-align:start;"> ' +
      '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
      '      ' + data + ' ' +
      '    </button> ' +
      '    <div class="dropdown-menu"> ' +
      '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>    ' +
      '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
      '</div>';
    return retorno;
  };

  ConsultaCSTICMS();

  $("#btnConsultar").on("click", async function () {
    await ConsultaCSTICMS(true);
    $("#modal-filtros").modal("hide");
  });

  $("#btnLimparFiltros").on("click", async function () {
    $("#txtCSTICMSconsulta").val("");
  });

  async function ConsultaCSTICMS(bBotao = false) {
    let response;
    try {
      $.LoadingOverlay("show");

      let codigo =
        pegaChave("#txtCSTICMSconsulta") != ""
          ? ` AND CODIGO = '${pegaChave("#txtCSTICMSconsulta")}'`
          : "";
      if (bBotao) {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          `JSON={ "tabela":"tabtri", "camposSelect":[ "codigo", "descricao"], "where": ["1=1 ${codigo}"]}`,
          null
        );
      } else {
        response = await requisicao(
          "GET",
          "/Sisplan/Funcoes/V1/pesquisa?",
          'JSON={ "tabela":"tabtri", "camposSelect":[ "codigo", "descricao"], "where": null}',
          null
        );
      }

      if (!response) {
        $.LoadingOverlay("hide");
        return;
      }

      let jsonStr = await response.json();
      if (response.status != 200) {
        $.LoadingOverlay("hide");
        msgErro(jsonStr.RESULT[0].mensagem);
        return;
      }

      $("#tabelaClaTrib").DataTable({
        destroy: true,
        lengthChange: false,
        serverside: true,

        autoWidth: true,
        data: jsonStr.RESULT[0],
        columns: [
          {
            data: "CODIGO",
          },
          {
            data: "DESCRICAO",
          },
        ],
        columnDefs: [
          {
            targets: [0], render: function (data, type, row) {
              return retornaBotaoOpcoes(data);
            }
          },
        ],
      });

      $.LoadingOverlay("hide");
    } catch (error) {
      console.error(error);
      $.LoadingOverlay("hide");
    }
  }

  $("#tabelaClaTrib").on("click", "#btn-editar", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClaTrib").DataTable().row($(this).parents("tr")).data();
      let registroLiberado = await verificarRegistro("CLATRIB", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `clatrib/${data.CODIGO}`;
      }
    } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
    
  });

  $("#tabelaClaTrib").on("dblclick", "tr", async function () {
    if (permissaoUsuarioLogado.ALTERA == 'S') {
      let data = $("#tabelaClaTrib").DataTable().row($(this)).data();
      let registroLiberado = await verificarRegistro("CLATRIB", data.CODIGO);
      if (registroLiberado) {
        window.location.href = `clatrib/${data.CODIGO}`;
      }
    } else {
        msgAlertaSemConfirmacao("Sem permissão para alterar!");
    }
    
    
  });


  $('#tabelaClaTrib').on('click', '#btn-excluir', async function () {
    if (permissaoUsuarioLogado.EXCLUI == 'S') {
      msgAlerta('Você realmente deseja excluir esse registro?', async () => {
        const data = $("#tabelaClaTrib").DataTable().row($(this).parents("tr"));
        await excluiRegistro(data);
      });
    } else {
        msgAlertaSemConfirmacao("Sem permissão para excluir!");
    }

    
  });

  async function excluiRegistro(data) {
    try {
      $.LoadingOverlay("show");
      try {
        let valorLinha = data.data();
        let response = await requisicao("DELETE", "/Sisplan/Cadastros/v1/clatrib?", `CODIGOCLATRIB=${encodeURIComponent(valorLinha.CODIGO)}`, null);
        if (!response) {
          return;
        }
        if (response.status != 200) {
          let jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return;
        }

        toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
          toastClass: "success",
          iconClasses: {
            error: "alert-error",
            info: "alert-info",
            success: "alert-success",
            warning: "alert-warning",
          },
          positionClass: "toast-top-center",
          progressBar: true,
          timeOut: 3000,
          fadeOut: 1000,
          onHidden() {
            data.remove().draw(false);
          },
        }).css({
          "margin-top": "20%",
          width: "500px",
          "max-width": "500px",
        });

      } catch (error) {
        console.error(error);
      }
    } finally {
      $.LoadingOverlay("hide");
    }
  }
});

$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
    });
    driver.defineSteps([
      {
        element: "#btnFiltros",
        popover: {
          title: "Botão Filtros",
          description: "Clique aqui para filtrar a busca.",
          position: "right",
        },
      },
      {
        element: "#btnNovaClaTrib",
        popover: {
          title: "Botão Incluir",
          description:
            "Clique aqui para iniciar o cadastro de uma classificação tributária.",
          position: "right",
        },
      },
      {
        element: "#tabelaClaTrib",
        popover: {
          title: "Tabela de Classificações Tributárias",
          description: "Aqui estão os dados das classificações cadastradas.",
          position: "top",
        },
      },
    ]);
    driver.start();
  });
});
